function Car(n, sx, sy, speed, active) {
	this.name = n;
	this.sx = sx;
	this.sy = sy;
	this.bitmap = null;
	this.carSpeed = typeof speed !== 'undefined' ? speed : 10;
	this.active = typeof active !== 'undefined' ? active : false;
	this.length = Math.sqrt(sx * sx + sy * sy);
	this.distanceToSource = Number.MAX_VALUE;
	this.distanceToCrossing = Number.MAX_VALUE;
	this.isWaiting = false;
	this.isOnCrossroad = false;
	this.currentCrossroadId = null;
	this.turnSignal = "";
	this.turning = "";
	this.waitingStartTime = 0;

	//te pola służą do skorygowania pozycji pojazdu
	this.northEastOffset = {
		x: 0,
		y: 0
	};
	this.southWestOffset = {
		x: 0,
		y: 0
	};
	this.northWestOffset = {
		x: 0,
		y: 0
	};
	this.southEastOffset = {
		x: 0,
		y: 0
	};

	//17x10
	switch (n) {
		case 'trolejbus':
			this.southWestOffset.y = (-1) * this.sy;

			this.southEastOffset.x = (-1) * this.sx;
			this.southEastOffset.y = (-1) * this.sy - 3;

			this.northWestOffset.y = -22;

			this.northEastOffset.x = -this.sx;
			this.northEastOffset.y = -22;

			this.length -= 15;
			break;
		case 'smart':
		case 'smart2':
		case 'smart3':
		case 'smart4':
			this.southWestOffset.y = (-1) * this.sy;

			this.southEastOffset.x = (-1) * this.sx;
			this.southEastOffset.y = (-1) * this.sy;

			this.northWestOffset.y = -8;

			this.northEastOffset.x = -this.sx;
			this.northEastOffset.y = -8;

			this.length -= 5;
			break;
		case 'star':
		case 'star2':
		case 'star3':
		case 'star4':
			this.southWestOffset.y = (-1) * this.sy;

			this.southEastOffset.x = (-1) * this.sx;
			this.southEastOffset.y = (-1) * this.sy;

			this.northWestOffset.y = -10;

			this.northEastOffset.x = -this.sx;
			this.northEastOffset.y = -10;

			//this.length-=5;
			break;
		case 'porsche':
		case 'porsche2':
		case 'porsche3':
		case 'porsche4':
			this.southWestOffset.y = (-1) * this.sy;

			this.southEastOffset.x = (-1) * this.sx;
			this.southEastOffset.y = (-1) * this.sy;

			this.northWestOffset.y = -5;

			this.northEastOffset.x = -this.sx;
			this.northEastOffset.y = -5;

			this.length -= 5;
			break;
		case 'chevrolet':
		case 'chevrolet2':
		case 'chevrolet3':
		case 'chevrolet4':
			this.southWestOffset.y = (-1) * this.sy;

			this.southEastOffset.x = (-1) * this.sx;
			this.southEastOffset.y = (-1) * this.sy;

			this.northWestOffset.y = -2;

			this.northEastOffset.x = -this.sx;
			this.northEastOffset.y = -2;

			this.length -= 5;
			break;
	}

	this.northEastOffset.x += 3;
	this.northEastOffset.y += 5;

	this.southEastOffset.x += -9;
	this.southEastOffset.y += 3;

	this.northWestOffset.x += 20;
	//this.northWestOffset.y += 4;

	this.southWestOffset.x += -6;
	this.southWestOffset.y += -4;
}

Car.prototype.init = function(image) {
	var img = image;

	if (img != null) {
		var carSprite = new createjs.SpriteSheet({
			images: [img],
			frames: {
				width: this.sx,
				height: this.sy
			},
			animations: {
				northEast: [0],
				northWest: [1],
				southEast: [2],
				southWest: [3]
			}
		});

		this.bitmap = new createjs.BitmapAnimation(carSprite);
	}
}

//position without offsets
Car.prototype.getOriginalPosition = function() {
	var position = {
		x: 0,
		y: 0
	};

	switch (this.bitmap.currentAnimation) {
		case 'southWest':
			position.x = this.bitmap.x - this.southWestOffset.x;
			position.y = this.bitmap.y - this.southWestOffset.y;
			break;
		case 'southEast':
			position.x = this.bitmap.x - this.southEastOffset.x;
			position.y = this.bitmap.y - this.southEastOffset.y;
			break;
		case 'northWest':
			position.x = this.bitmap.x - this.northWestOffset.x;
			position.y = this.bitmap.y - this.northWestOffset.y;
			break;
		case 'northEast':
			position.x = this.bitmap.x - this.northEastOffset.x;
			position.y = this.bitmap.y - this.northEastOffset.y;
			break;
	}

	return position;
}

//position without offsets
Car.prototype.setPosition = function(position) {
	switch (this.bitmap.currentAnimation) {
		case 'southWest':
			this.bitmap.x = position.x - this.southWestOffset.x;
			this.bitmap.y = position.y - this.southWestOffset.y;
			break;
		case 'southEast':
			this.bitmap.x = position.x - this.southEastOffset.x;
			this.bitmap.y = position.y - this.southEastOffset.y;
			break;
		case 'northWest':
			this.bitmap.x = position.x - this.northWestOffset.x;
			this.bitmap.y = position.y - this.northWestOffset.y;
			break;
		case 'northEast':
			this.bitmap.x = position.x - this.northEastOffset.x;
			this.bitmap.y = position.y - this.northEastOffset.y;
			break;
	}
}

Car.prototype.getOriginalRearPosition = function() {
	var frontPosition = this.getOriginalPosition();
	var position = {
		x: 0,
		y: 0
	};
	return frontPosition;
	switch (this.bitmap.currentAnimation) {
		case 'southWest':
			position.x = frontPosition.x + this.sx;
			position.y = frontPosition.y - this.sy;
			break;
		case 'southEast':
			position.x = frontPosition.x - this.sx;
			position.y = frontPosition.y - this.sy;
			break;
		case 'northWest':
			position.x = frontPosition.x + this.sx;
			position.y = frontPosition.y + this.sy;
			break;
		case 'northEast':
			position.x = frontPosition.x - this.sx;
			position.y = frontPosition.y + this.sy;
			break;
	}

	return position;
}

Car.prototype.translate = function(translationVector) {
	if (this.isWaiting)
		return;
	this.bitmap.x += translationVector.items[0];
	this.bitmap.y += translationVector.items[1];
}

Car.prototype.chooseRandomDirection = function() {
	var possibleDirections = [];

	if (this.bitmap.currentAnimation != "northEast" && window.game.map.traffic.crossroads[this.currentCrossroadId].westSouth != null)
		possibleDirections.push("southWest");

	if (this.bitmap.currentAnimation != "northWest" && window.game.map.traffic.crossroads[this.currentCrossroadId].eastSouth != null)
		possibleDirections.push("southEast");

	if (this.bitmap.currentAnimation != "southEast" && window.game.map.traffic.crossroads[this.currentCrossroadId].westNorth != null)
		possibleDirections.push("northWest");

	if (this.bitmap.currentAnimation != "southWest" && window.game.map.traffic.crossroads[this.currentCrossroadId].eastNorth != null)
		possibleDirections.push("northEast");

	this.turnSignal = possibleDirections[Math.floor((Math.random() * possibleDirections.length))];

	this.turning = this.getTurning();
}

Car.prototype.changeDirection = function() {
	var possibleDirections = [];

	if (this.turnSignal != "southWest" && this.bitmap.currentAnimation != "northEast" && window.game.map.traffic.crossroads[this.currentCrossroadId].westSouth != null)
		possibleDirections.push("southWest");

	if (this.turnSignal != "southEast" && this.bitmap.currentAnimation != "northWest" && window.game.map.traffic.crossroads[this.currentCrossroadId].eastSouth != null)
		possibleDirections.push("southEast");

	if (this.turnSignal != "northWest" && this.bitmap.currentAnimation != "southEast" && window.game.map.traffic.crossroads[this.currentCrossroadId].westNorth != null)
		possibleDirections.push("northWest");

	if (this.turnSignal != "northEast" && this.bitmap.currentAnimation != "southWest" && window.game.map.traffic.crossroads[this.currentCrossroadId].eastNorth != null)
		possibleDirections.push("northEast");

	this.turnSignal = possibleDirections[Math.floor((Math.random() * possibleDirections.length))];
	//console.log(possibleDirections);
	this.turning = this.getTurning();
}

Car.prototype.getTurning = function() {
	if (this.bitmap.currentAnimation == this.turnSignal)
		return "straight";
	else if (this.bitmap.currentAnimation == "southWest" && this.turnSignal == "northWest" || this.bitmap.currentAnimation == "southEast" && this.turnSignal == "southWest" || this.bitmap.currentAnimation == "northEast" && this.turnSignal == "southEast" || this.bitmap.currentAnimation == "northWest" && this.turnSignal == "northEast")
		return "right";
	else if (this.bitmap.currentAnimation == "northWest" && this.turnSignal == "southWest" || this.bitmap.currentAnimation == "southWest" && this.turnSignal == "southEast" || this.bitmap.currentAnimation == "southEast" && this.turnSignal == "northEast" || this.bitmap.currentAnimation == "northEast" && this.turnSignal == "northWest")
		return "left";

	return "";
}
